/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.query.IVWScopeChangeListener;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class VWSelectColumnsPanel
extends JPanel
implements IVWScopeChangeListener {
    private VWAddRemovePanel m_addRemovePanel = null;

    public VWSelectColumnsPanel() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setLayout(new BorderLayout());
            this.m_addRemovePanel = new VWAddRemovePanel(48);
            this.m_addRemovePanel.setAvailableItemName(VWResource.s_availableColumns);
            this.m_addRemovePanel.setSelectedItemName(VWResource.s_selectedColumns);
            this.m_addRemovePanel.enableSorting(256);
            this.add((Component)this.m_addRemovePanel, "Center");
            VWAccessibilityHelper.setLabelFor(this.m_addRemovePanel.getAvailableLabel(), this.m_addRemovePanel.getAvailableJList());
            VWAccessibilityHelper.setLabelFor(this.m_addRemovePanel.getSelectedLabel(), this.m_addRemovePanel.getSelectedJList());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getDisplayName() {
        return VWResource.s_resultsOptions;
    }

    public String[] getSelectedColumns() {
        if (this.m_addRemovePanel != null) {
            return this.m_addRemovePanel.getSelectedStringItems();
        }
        return null;
    }

    public void scopeChanged(VWScopeChangeEvent event) {
        Object[] availableItems = null;
        String[] defaultItems = null;
        Vector<String> items = null;
        Object[] selectedItems = null;
        try {
            availableItems = event.getAvailableColumns();
            defaultItems = event.getDefaultColumns();
            if (defaultItems != null) {
                items = new Vector<String>();
                for (int i = 0; i < defaultItems.length; ++i) {
                    if (!this.isInArray(defaultItems[i], (String[])availableItems)) continue;
                    items.addElement(defaultItems[i]);
                }
                selectedItems = new String[items.size()];
                items.copyInto(selectedItems);
            }
            this.m_addRemovePanel.initializeLists(availableItems, selectedItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean isInArray(String itemName, String[] items) {
        if (itemName == null || items == null) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (VWStringUtils.compareIgnoreCase(itemName, items[i]) != 0) continue;
            return true;
        }
        return false;
    }
}

